#Welcome to Intro to Python!
#The type of text file is known as a Python file, it will open with any Python IDE
#Right now we are using my favorite Python IDE, Spyder. Spyder is part of the 
#Anaconda Distribution, which also includes the Jupyter Notebook and support
#For RStudio.
#This pane of Spyder is where we have all our code, our output will appear in
#the Anaconda console over yonder >>>>>>

#We can see how Python is behaving when we do simple addition. Press F9 to run a 
#selection of code, or a single line if nothing is selected
2+2
#We can use the same operation to create a new variable, in this case we are creating
#a new variable, x,  which is the same sum
x = 2+2
#We have added this new object to our environment. If we look over towards the 
#console we can see a tab down low called 'variable explorer'
#The print function just outputs whatever we have decided to print
print(x)
#To see more info on any function just the command preceded by a ?
?print
#WARNING Printing an object this way is unique to Python3, if you ever see the 
#print function used like this...
print x
#The coder is using an earlier version of Python.

#In addition to creating objects, we can create objects from other objects
#First we assign a value to x
x = 4
#Then we make y be the same value as x
y = x
#Here is where things get tricky, instead of saving y as automatically being
#the same as x, Python actually assigns y to be the value of x originally
x = 6
#This means that over though we changed x, y remain unaffected
y
#We can see some basic mathematical operations
#Division
2 / 3
#Multiplication
2*3
#This is NOT cubing two, the carrot is a bitwise XOR operator
2^3
#Exponents are represented as such
2**3
2-3
#The single percent sign assess the remainder
14%4
#The double equal sign assesses the equivalence of two values and returns
#a logical (or boolean), which is just True or False
5 == 4
#Most of the funcitonality of Python is stored in libraries
#to load a library we have run the import function like so...
from math import *
#This loads the math library and the * means to import eveyr function of the library
#The following are all functions from the math library
sqrt(17)
#The ceil function returns the next whole number
ceil(2.33)
#Also in the library are particular values
sin(pi)
e
#In fact, if we glance over at our Variable explorer, we can see the new values
#In addition to making single values (scalars), we can create a vector
x = 1,2,3,4,5
x
#Now that we have a vector of values, we can begin slicing it up to get particular values 
#Remember! Python indexes at zero, like C++ and Java
#So this returns the first element of x
x[0]
#And this line returns the second through fourth values
x[1:4]
#Also beware that because Python indexes at zero, it goes *up to* the fifth
#element, but does not return it
#The negative value will return the second from last
x[-2]
#Just like with our scalars, we can run functions on vectors
max(x)
#Let's talk a little about data types...PYthon has support for a variety of
#different variable types. The first type is the integer
integers = 2,47,190234
#The type function returns the type of the variable, indeed 47 is an integer
type(47)
#We can also search for certain values in our vector
2 in integers
#This returns a boolean, and speaking of booleans...
#The object created by this inequality is a True/False statement
Boolean = 3 > 4
#So when we print it, we get a simple False output
print(Boolean)
#And if we ask for the data type...
type(Boolean)
#The string data type is also widely used in Python, especially in NLP applications
#Strings represent text and are essentially used as such
string = 'Python is a fun language'
type(string)
#With a string variable, each character (as oppposed to word) is an element
string[2:12]
#The len function returns the length of the vector, in this case we have 24 characters
len(string)
#We can also add strings together!
"Python" + " is a fun language"
#And we can also search for particular strings within strings
'th' in string
#Floats are used to represent decimals
floatingpoint = 3.141592
type(floatingpoint)
#Lists are used to store different data types together
listoftypes = 3 + 4, 3.0 + 4.0, '3' + '4'
#We have created an object with an integer, a float, and a string
listoftypes

#Now we are going to move on to a little bit on conditional statements. 
#Conditional statements begin with a boolean, and then perform a function based
#on the result of the boolean. For our example we are evaluating whether x is greater
#than four, and then printing according to that result 
x = 3
if x > 4:
    print('x is a larger number')
else:
    print('x is a small number')
#Conditionals don't always need an else option if we simply want to specify a
#single condition    
if type(x) == int:
    print('x is an integer')
#In this set up, if the condition is false, nothing will happen
#Now let's add another layer to our condition statement, first we want to 
#evaluate if x in an integer, and then evaluate based on the value of x
x = '3'
if type(x) != int:
    print('x is NOT an integer')
elif x > 4: 
    print('x is a large number')
else: 
    print('x is a small number')
#Let's dissect this a little bit. We began by testing whether x was an integer,
#We did this by using '!=' which translates to testing whether two things are not equal
#In this case, we tested whether x was NOT an integer, then only if this was false
#did we test the magnitude. We also added a new function 'elif', this is short 
#for 'else if' and is useful if we have intermediate conditionals, there is no 
#limit to how many elif's we can specify

#Let's have a little more fun with conditionals. We are going to start by creating
#an object based on input (using the input function), the 'quiz' object will be
 #our response to the input
quiz  = input('What is the capital of Minnesota? (A) Minneapolis\
 (B) St. Paul (C) Duluth or (D) Madison \nAnswer: ' )
quiz
#Now that we have our answer, we can run it through a conditional to give us 
#output based on our answer
if quiz == 'A':
    print('Good guess, but wronggggggg!!!')
elif quiz == 'B':
    print('Correct! The capital is St. Paul, which is also home to the Minnesota Wild, Go Wild!')
elif quiz == 'C':
    print('Nah, Duluth is too small to be the capital. However it is a lovely little town')
elif quiz == 'D':
    print('Lol. Madison is not even in Minnesota')
elif quiz == 'idc':
    print('I dont blame you, you will never need to know that')
else:
    print('Not a real option.')
#You can see that based on what the answer to the question we have different output,
#And then if the person answered something other than an option, we can tell them

#Now let's move on to loops. Loops are used extensively when we want to repeat
#an operation a specified number of times. We need to begin by specifying how many
#iterations we want, followed by the operation we want to do.
for i in range(100):
    print('This is a really repetitive for loop')
#Here we are iterating 100 times, the i used here is arbitrary, but is short for iteration
#Then we are just printing the same thing 100 times
#We can use our iteration value as a part of the loop itself...
for i in range(100):
    print('This is a really repetitive for loop for the', i, 'th time')

#If we want, we can increase our values by something other than one
#the += menas that for each iteration we are increasing x by 2
x = 10
for i in range(100):
    x += 2
    print(x)
#We can also nest for loops in each other. The lower for loop will run for each iteration
#of the higher for loop. In this case the ten iterations of j are occuring for 
 #each of the ten i iterations, meaning we are performing 100 additions
for i in range(10):
    for j in range(10):
        sum = i + j
        print('The sum is:', sum)
#We can use our value of i to subset the data, meaning we run our operation on each
#particular value of a vector. Here we are running a conditional statement for each
#value of vector x, and iterating over the entire length of x        
x = 3,10,-11, 12,4,5,4,8
for i in range(len(x)):
    if x[i] >= 10:
        print('The', i, 'th number of x is large')
    else:
        print('The', i, 'th number of x is small')

#Creating our own functions in Python is pretty straightforward, we need to use
#the 'def' function, then type in the operation. In this case we are assessing
#the size of an x value
def largenumber():
    x = input('Provide a value for x:')
    x = int(x)
    if x >= 100:
        print('X is a large number')
    elif x >= 50:
        print('X is a medium number')
    else:
        print('X is a small number')
largenumber()
#This function first gets user input for the value of x, then converts x from 
#a string to an integer, then runs a very similar conditional statement to the 
#ones we have been using so far.
#Let's look at a little more practical function, here we are codign a function
#to convert Fahrenheit to Celsius
def FtoC(Fahrenheit):
    (Fahrenheit - 32) * (5/9)
FtoC(12)
#We ran it....but where is a our value? By default we won't get out put unless we add
#an additional function to return our value
def FtoC(Fahrenheit):
    Celsius = (Fahrenheit - 32) * (5/9)
    return Celsius
FtoC(12)
#That's more like it. Here our Fahrenheit temperature is being used as an argument
#Arguments are any options for a given function
#We can integrate the print function to give us a little bit better output
def FtoCout(Fahrenheit):
    Celsius = (Fahrenheit-32) * (5/9)
    print("The temperature is", Celsius, "degrees Celsius.")
FtoCout(45)
#We can then use our new function in other functions, here we are creating a function
#to output the conversion for 0 through 100 degrees Fahrenheit. We are also using
#a for loop to provide the arguments for our FtoC function
def FtoCTable():
    for Fahrenheit in range(100):
        Celsius = FtoC(Fahrenheit)
        print(Fahrenheit, "degrees Fahrenheit is equal to", Celsius, "degrees Celsius")
FtoCTable()

#Now create the inverse...create a function to go from Celsius to Fahrenheit
#then run a for loop converting each Celsius value from -5 to 45 in intervals of .5

#Let's dive a little deeper into using libraries in Python, here we are going to 
#be using the numpy library
#Importing every function from numpy...
from numpy import *
#Here we are actually importing the numpy library and renaming it np
#this is handy because as we are about to see, using libraries often requires
#calling the library specifically
import numpy as np
#here we are specifying a random seed, and telling Python to find the 'seed' function
#in the 'random' module in the 'np' library
np.random.seed(5692)
#Here we are using this randomness to create a one dimensional vector of size
#six, with vlaues up to ten
x1 = np.random.randint(10, size = 6)
x1
#Here we are using the same logic, but creating a 5x6 matrix with a max of ten
x2 = np.random.randint(10, size = (5,6))
x2
#Again, same basic lgoic, but now we are going to have a 7x8x5 array of max 100
#All of these objects were created using numpy functions, and the use of Python
#libraries will look like this.
x3 = np.random.randint(100, size = (7,8,5))
x3
0 in x3
#Each numpy object contains special characteristics. The array we created has
#information related to shape and size. In Python we access these characteristics
#by specifying the object, a period, then the characteristic
print('x3 dim:', x3.ndim)
print('x3 shape:', x3.shape)
print('x3 size:', x3.size)
print('itemsize:', x3.itemsize, 'bytes')
#Similarly, numpy has additional mathematical functions that we can apply across
#objects in a vector. So we specify the library, then the function. 
#Our arguments are then our vector
x = [1,2,3]
print('x = ', x)
print('e^x =', np.exp(x))
print('2^x = ', np.exp2(x))
print('3^x = ', np.power(3, x))

#Likewise, mos tof hte same functions work with matrices. Here we create a 3x4
#matrix, then get characteristics of that matrix
Matrix = np.random.random((3,4))
print(Matrix)
Matrix.sum()
Matrix.min(axis = 0)
Matrix.max(axis = 1)

#numpy also has functions for creating matrices of a specific value, here a 3x
#matrix of ones
ones = np.ones((3,3))
ones
#And then we can perform most of our same mathematics operations
a=5
ones+a

#Let's finish by briefly looking at some options for graphing. The numpy library
#can let us create sequences of variables, x is going to be zero through 5
#with 50 values
x = np.linspace(0, 5, 50)
x
#So will y, but we are going to create a new row for each value (so it's vertical)
y = np.linspace(0, 5, 50)[:, np.newaxis]
y
#Then we are going to use this nasty equation to create a vector, z
z = np.sin(x) ** 10 + np.cos(10 + y*x) + np.cos(x)
#matplotlib is a classic plotting library, meant to mimic MATLAB plots
import matplotlib.pyplot as plt
plt.imshow(z, origin = 'lower', extent = [0, 5, 0 ,5], cmap = 'viridis')
plt.colorbar()
#This is just a sampling of what can be done with Python. Because Python is a 
#general purpose language, there are alot of potential avenues we can go, but
#this shoudl at least provide a basic underpinning for how Python operates.